//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 3:Multidimensional Steady-State Heat Conduction
//Example :3.1 page 95
//Topic:Temperature at the centre of the plate
//===================================================================================

model Ex3_1
extends Modelica.Math;
extends Modelica.Constants;

//=================================
//Parameter section

parameter Real T1(unit="degree celcius")=100"Temperature at first edge";
parameter Real T2(unit="degree celcius")=200"Temperature at second edge";
parameter Real T3(unit="degree celcius")=400"Temperature at third edge";
parameter Real T4(unit="degree celcius")=100"Temperature at fourth edge";
parameter Real n1(unit="")=1"First term of the series";
parameter Real n2(unit="")=2"Second term of the series";
parameter Real n3(unit="")=3"Third term of the series";
parameter Real x(unit="")=0.5"point of convergence x";
parameter Real y(unit="")=0.5"point of convergence y";

//===================================
//Variable section

Real O1(unit="")"Value at (0.5,0.5) for module 1";
Real O2(unit="")"Value at (0.5,0.5) for module 2";
Real O(unit="")"Sum of O1 and O2";
Real T(unit="degree celcius")"The temperature at the centre of the plate";

//===================================
//Equation section

equation
O1=(2/pi)*((((sinh(n1*pi*(1-x)))/(sinh(n1*pi)))*(sin(n1*pi*y))*((((-1)^(n1+1))+1)/n1))+(((sinh(n2*pi*(1-x)))/(sinh(n2*pi)))*(sin(n2*pi*y))*((((-1)^(n2+1))+1)/n2))+(((sinh(n3*pi*(1-x)))/(sinh(n3*pi)))*(sin(n3*pi*y))*((((-1)^(n3+1))+1)/n3)));
O2=3*O1;
O=O1+O2;
T=(O*(T2-T1))+T1;

end Ex3_1;
