//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 3:Multidimensional Steady-State Heat Conduction
//Example :3.2 page 96
//Topic:A thin square plate
//===================================================================================

model Ex3_2
extends Modelica.Constants;
extends Modelica.Math;

//==================================
//Parameter section

parameter Real a(unit="")=1"Assuming a=1";
parameter Real x(unit="")=a/2"Centre point of the module";
parameter Real y(unit="")=a/2"Centre point of the module";
parameter Real T1(unit="K")=300"Temperature at edge DA";

//==================================
//Variable section

Real O1(unit="")"Temperature distribution at module 1";
Real O2(unit="")"Temperature distribution at module 2";
Real O(unit="")"Temperature distribution of plate";
Real T2(unit="K")"Temperature distribution at edge CD";
Real T(unit="")"Temperature at centre";

//===================================
//Equation section

equation

O1=2*(sinh(pi*y/a))*(sin(pi*x/a))/(sinh(pi));
O2=(sinh(pi*x/a))*(sin(pi*y/a))/(sinh(pi));
O=O1+O2;
T2=T1+(100*sin(pi*y/a));
T=(O*(T2-T1))+T1;
 
end Ex3_2;
