//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 3:Multidimensional Steady-State Heat Conduction
//Example :3.5 page 116
//Topic:An aluminium rod
//===================================================================================

package Ex3_5

//==================================================================================

model Ex3_5_a
extends Modelica.Constants;
extends Modelica.Math;

//=================================
//parameter section

parameter Real Tb(unit="degree celcius")=400"Tempeature at node 1";
parameter Real To(unit="degree celcius")=30"Ambient temperature";
parameter Real k(unit="W/mK")=200"Thermal conductivity of aluminium rod";
parameter Real h(unit="W/m^2K")=40"Convective heat transfer coefficient";
parameter Real d(unit="mm")=20"Diameter of the rod";
parameter Real L(unit="m")=0.2"Length of the rod";
parameter Real x2(unit="m")=0.04"Distance of node 2";
parameter Real x3(unit="m")=0.08"Distance of node 3";
parameter Real x4(unit="m")=0.12"Distance of node 4";
parameter Real x5(unit="m")=0.16"Distance of node 5";
parameter Real x6(unit="m")=0.2"Distance of node 6";
//=================================
//Variable section

Real T2(unit="degree celcius")"Temperature at node 2";
Real T3(unit="degree celcius")"Temperature at node 3"; 
Real T4(unit="degree celcius")"Temperature at node 4";
Real T5(unit="degree celcius")"Temperature at node 5";
Real T6(unit="degree celcius")"Temperature at node 6";

//===================================
//Equation section

equation

(2.064*T2)-T3=398.08;
(2.064*T3)-T2-T4=1.92;
(2.064*T4)-T3-T5=1.92;
(2.064*T5)-T4-T6=1.92;
(1.032*T6)-T5=0.96;

end Ex3_5_a;
//=================================================================================

model Ex3_5_b
extends Ex3_5_a;

//================================
//Variable section 

Real Qn(unit="W")"Rate of heat loss by numerical method";

//================================
//Equation section

equation

Qn=k*pi*((d/1000)^2)*(Tb-T2)/(4*x2);

end Ex3_5_b;
//==================================================================================

model Ex3_5_c
extends Ex3_5_a;

//================================
//Variable section 

Real m(unit="")"";
Real Ta2(unit="degree celcius")"Temperature at node 2 by Analytical method";
Real Ta3(unit="degree celcius")"Temperature at node 3 by Analytical method"; 
Real Ta4(unit="degree celcius")"Temperature at node 4 by Analytical method";
Real Ta5(unit="degree celcius")"Temperature at node 5 by Analytical method";
Real Ta6(unit="degree celcius")"Temperature at node 6 by Analytical method";
Real Qa(unit="W")"Rate of heat loss by Analytical method";

//================================
//Equation section

equation

m=sqrt((h*pi*(d/1000)*4)/(k*pi*((d/1000)^2)));
Ta2=30+(193.61*cosh(6.32*(L-x2)));
Ta3=30+(193.61*cosh(6.32*(L-x3)));
Ta4=30+(193.61*cosh(6.32*(L-x4)));
Ta5=30+(193.61*cosh(6.32*(L-x5)));
Ta6=30+(193.61*cosh(6.32*(L-x6)));
Qa=sqrt(h*pi*(d/1000)*k*(pi/4)*((d/1000)^2))*tanh(m*L)*(Tb-To);

end Ex3_5_c;
//==================================================================================

end Ex3_5;

//==================================================================================
//Remarks
//(Tb-To) is a part of the formula but is not mentioned in the book.
