//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.12 page 170
//Topic:A large block of nickel steel
//===================================================================================

model Ex4_12
extends Modelica.Math;
extends Modelica.Constants;

//=================================
//parameter section

parameter Real Ti(unit="degree celcius")=30"Initial temperature of the nickel-steel block";
parameter Real qo(unit="MW/m^2")=6"Constant surface heat flux";
parameter Real x(unit="mm")=100"Depth of the block";
parameter Real t(unit="seconds")=100"Time at which temperature to be found";
parameter Real k(unit="W/mK")=20"Thermal conductivity of the block";
parameter Real a(unit="m^2/s")=0.518e-5"Thermal diffusivity of the block";

//=================================
//Variable section

Real n(unit="")"Similarity Variable";
Real r(unit="")"Constant";
Real T(unit="degree celcius")"Temperature at the required depth and time";

//=================================
//Equation section

equation

n=(x*1e-3)/(sqrt(4*a*t));
//erf(n) Value is taken from Table 4.4 (0.99814)
r=n^2;
T=Ti+(((2*qo*(1e6)*sqrt(a*t/pi))/k)*(exp(-r)))-(((qo*(1e6)*(x*1e-3))/k)*(1-0.99814));

end Ex4_12;

//===============================================================
//Remarks
//The value of T is wrong in book.
