//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.2 page 132
//Topic:Temperature of gas stream
//===================================================================================

package Ex4_2

//===============================================================
  model Ex4_2_a
  extends Modelica.Constants;
  extends Modelica.Math;
//=========================================
//parameter section

parameter Real d(unit="mm")=1.5"Diameter of the sphere";
parameter Real k(unit="W/mK")=40"Thermal conductivity of the junction";
parameter Real rho(unit="kg/m^3")=8000"Density of the junction";
parameter Real Cp(unit="J/kgK")=300"specific heat capacity of the junction"; 
parameter Real h(unit="W/m^2K")=75"Heat transfer coefficient between the junction";

//=========================================
//Variable section

Real r(unit="m")"Radius of the sphere";
Real V(unit="m^3")"Volume of the sphere";
Real As(unit="m^2")"Area of the sphere";
Real tc(unit="seconds")"Time constant of the thermocouple";

//=========================================
//Equation section

equation
r=(d/1000)/2;
V=(4/3)*pi*(r^3);
As=4*pi*r^2;
tc=(rho*Cp*V)/(h*As);

end Ex4_2_a;
//=========================================================================================
  
  model Ex4_2_b
  extends Ex4_2_a;
//======================================== 
//Variable section

Real t(unit"seconds")"Time taken to read a temperature";

//========================================
//Equation section

equation
t=(-tc)*(log(0.01));

end Ex4_2_b;


//========================================================================================== 
end Ex4_2;
