//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.3 page 133
//Topic:Maximum edge dimension
//===================================================================================

model Ex4_3

//================================
//parameter section

parameter Real h(unit="W/m^2K")=30"Convective heat transfer coefficient of aluminium";
parameter Real k(unit="W/mK")=250"Thermal conductivity of aluminium";
parameter Real Bi(unit="")=0.1"Biot number for maximum edge dimension";

//================================
//Variable section

Real a(unit="m")"Maximum edge dimension of the aluminium solid";

//================================
//Equation section

equation
a=(Bi*k*6)/h;

end Ex4_3;
