//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.4 page 133
//Topic:Hot milk
//===================================================================================

package Ex4_4

//===================================================================================
model Ex4_4_a
extends Modelica.Constants;
extends Modelica.Math;

//====================================
//parameter section

parameter Real d(unit="mm")=50"Diameter of the glass";
parameter Real ht(unit="mm")=100"Height of the glass";
parameter Real Tc(unit="degree celcius")=25"Temperature of the cold water";
parameter Real Ti(unit="degree celcius")=80"Initial temperature of the milk";
parameter Real Tf(unit="degree celcius")=30"Final temperature of the milk to be cooled";
parameter Real h(unit="W/m^2K")=100"Heat transfer coefficient between glass and water";
parameter Real k(unit="W/mK")=0.6"Thermal conductivity of the milk";
parameter Real rho(unit="kg/m^3")=900"Density of the milk";
parameter Real Cp(unit="kJ/kgK")=4.2"Specific heat of the milk";

//=====================================
//Variable section

Real V(unit="m^3")"Volume of the glass";
Real As(unit="m^2")"Area of the glass";
Real tc(unit="minutes")"Time constant";
Real t(unit="minutes")"Time taken for the milk to cool down ";

//=====================================
//Equation section

equation
V=(pi/4)*((d/1000)^2)*(ht/1000);
As=pi*(d/1000)*(ht/1000);
tc=(rho*Cp*1000*V)/(h*As)/60;
t=(-tc)*log((Tf-Tc)/(Ti-Tc)); 

end Ex4_4_a;

//=================================================================================

model Ex4_4_b
extends Ex4_4_a;
//=====================================
//Variable section

Real E(unit="kJ")"Total amount of energy transferred during cooling";

//=====================================
//Equation section

equation
E=h*As*(Ti-Tc)*(tc*60)*(1-(e^((-t*60)/(tc*60))))/1000;

end Ex4_4_b;

//==================================================================================
end Ex4_4;
