//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.5 page 156
//Topic:Masonry brick wall
//===================================================================================

package Ex4_5

//===================================================================================
model Ex4_5_a

//=====================================
//parameter section

parameter Real k(unit="W/mK")=0.6"Thermal conductivity of masonry wall";
parameter Real a(unit="m^2/s")=5e-7"Thermal diffusivity of the wall";
parameter Real L(unit="mm")=150"Thickness of the wall";
parameter Real Ti(unit="degree celcius")=30"Initial temperature of the wall";
parameter Real Tg(unit="degree celcius")=780"Temperature of hot gas";
parameter Real To(unit="degree celcius")=480"Final temperature to be attained";
parameter Real h(unit="W/m^2K")=20"Heat transfer coefficient on the hot gas side";

//=====================================
//Variable section

Real t(unit="hours")"Time required to attain the temperature";
Real Bi(unit="")"Biot number";

//=====================================
//Equation section

equation

Bi=(h*L)/(1000*k);
t=(0.6*(L/1000)^2)/(a*3600);//Fo=0.6 from Figure(graph) 4.11 at (1/Bi)

end Ex4_5_a;
//===============================================================================

model Ex4_5_b
extends Ex4_5_a;

//======================================
//Variable section

Real Qi(unit="J")"Heat transfered per unit area initially";
Real Q(unit="MJ")"Heat transfer per unit area at that time ";

//======================================
//Equation section

equation
Qi=(0.6/a)*(2*L/1000)*(Tg-Ti);
Q=0.69*Qi*1e-6;//(Q/Qi) ratio is 0.69 from the Figure(graph) 4.13 at Bi and Fo(Bi^2)

end Ex4_5_b;


//===============================================================================
end Ex4_5;
