//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.6 page 156
//Topic:A large aluminium plate
//===================================================================================

model Ex4_6

//======================================
//parameter section

parameter Real Ti(unit="degree celcius")=530"Initial temperature of aluminium plate";
parameter Real Ta(unit="degree celcius")=30"Ambient temperature";
parameter Real h(unit="W/m^2K")=500"Convective heat transfer coeffient between plate and environment";
parameter Real k(unit="W/mK")=200"thermal conductivity of the aluminium plate";
parameter Real a(unit="m^2/s")=8e-5"Thermal diffusivity of aluminium plate";
parameter Real t(unit="seconds")=225"Time the plate exposed to environment";
parameter Real L(unit="mm")=200"Thickness of the plate";
parameter Real d(unit="mm")=20"Depth at which temperature measured";

//=======================================
//Variable section

Real Bi(unit="")"Biot number";
Real X(unit="m")"Length excluding the depth";
Real Fo(unit="")"Fourier number";
Real T(unit="degree celcius")"Temperature at 20mm depth";
Real Qi(unit="J")"Energy lost per unit area initially";
Real Q(unit="MJ")"Energy lost per unit area during this time";

//=======================================
//Equation section

equation
Bi=(h*L)/(1000*k);
X=0.1-(d*1e-3);
Fo=(a*t)/(((L*1e-3)/2)^2);
//(To-Ta)/(Ti-Ta)=0.7 taken from figure(graph) 4.11 at (1/Bi) and Fo
//(T-Ta)/(To-Ta)=0.93 taken from figure(graph) 4.12 at (1/Bi) and (X/L)
T=Ta+(0.93*0.7*(Ti-Ta));
Qi=(k/a)*(L/1000)*(Ti-Ta);//L=2L=200mm
Q=Qi*0.4e-6;//(Q/Qi) ratio is 0.4 taken from figure 4.13 at Fo(Bi^2)

end Ex4_6;
