//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.8 page 158
//Topic:A steel sphere
//===================================================================================

model Ex4_8

//=================================
//parameter section

parameter Real ro(unit="mm")=50"Radius of the steel sphere";
parameter Real Ti(unit="degree celcius")=530"Initial uniform temperature of the sphere ";
parameter Real Ta(unit="degree celcius")=30"Temperature of oil in which sphere is immersed";
parameter Real h(unit="W/m^2K")=500"Convective heat transfer coefficient ";
parameter Real k(unit="W/mK")=50"Thermal conductivity of steel sphere";
parameter Real a(unit="m^2/s")=1.5e-5"Thermal diffusivity of steel";
parameter Real To(unit="degree celcius")=105"Temperature to be attained at centre of the sphere";

//=================================
//Variable section

Real T(unit="")"";
Real Bi(unit="")"Biot number";
Real t(unit="min")"Time to reach the required temperature";

//==================================
//Equation section

equation

T=(To-Ta)/(Ti-Ta);
Bi=(h*ro)/(1000*k);
//Fo=1.5 at T and Bi from figure(graph) 4.19
t=(1.5*((ro*1e-3)^2))/(a*60);

end Ex4_8;
