//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.9 page 163
//Topic:A large aluminium bar
//===================================================================================

model Ex4_9

//=================================
//parameter section

parameter Real k(unit="W/mK")=198"Thermal conductivity of aluminium bar";
parameter Real Ti(unit="degree celcius")=730"Initial temperature of the bar";
parameter Real Ta(unit="degree celcius")=30"Ambient temperature";
parameter Real h(unit="W/m^2K")=1100"Convective heat transfer coefficient";
parameter Real a(unit="m^2/s")=8.1e-5"Thermal diffusivity of the bar";
parameter Real t(unit="seconds")=100"Time at which temperature to be found";
parameter Real L(unit="mm")=180"cross section of the plate 1";
parameter Real B(unit="mm")=104"Cross section of the plate 2";

//=================================
//Variable section

Real L1(unit="m")"Thickness of plate 1";
Real L2(unit="m")"Thickness of plate 2";
Real Fo1(unit="")"Fourier number for plate 1";
Real Bi1(unit="")"Biot number for plate 1";
Real Fo2(unit="")"Fourier number for plate 2";
Real Bi2(unit="")"Biot number for plate 2";
Real To(unit="degree celcius")"Temperature at the centre of the bar at given time";

//=================================
//Equation section

equation

L1=(L*1e-3)/2;
Fo1=(a*t)/(L1^2);
Bi1=(h*L1)/k;
//Tp1=(To-Ta)/(Ti-Ta)=0.7 from figure(graph) 4.11 at Fo1 and (1/Bi1)
L2=(B*1e-3)/2;
Fo2=(a*t)/(L2^2);
Bi2=(h*L2)/k;
//Tp2=(To-Ta)/(Ti-Ta)=0.47 from figure(graph) 4.11 at Fo2 and (1/Bi2)
//((To-Ta)/(Ti-Ta))bar = Tp1 * Tp2
To=Ta+(0.7*0.47*(Ti-Ta));

end Ex4_9;
