//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 5:Convection
//Example :5.6 page 218
//Topic:Air enters a tube
//===================================================================================

model Ex5_6

//=================================
//parameter section

parameter Real Tb(unit="degree celcius ")=30"Temperature of air at 1 atm pressure";
parameter Real d(unit="mm")=25"Diameter of the tube";
parameter Real u(unit="m/s")=10"Velcoity of air";
parameter Real q(unit="kW/m^2")=2"Heat flux";
parameter Real T(unit="degree celcius")=20"Temperature of the wall";
parameter Real L(unit="m")=2"Length of the tube";
parameter Real rho(unit="kg/m^3")=1.2"Density of air";
parameter Real Cp(unit="J/kgK")=1e3"Specific heat capacity of air";

//=================================
//Variable section

Real Tb2(unit="degree celcius")"Outlet temperature of air";
Real hx(unit="W/m^2K")"Heat tramsfer coefficient at any distance x";
Real Nu(unit="")"Nusselt Number";

//=================================
//Equation section

equation

Tb2=Tb+(8*q*1e3)/(rho*d*1e-3*u*Cp);
hx=(q*1e3)/T;//T=(Tw-Tb)
Nu=(hx*L*d*1e-3)/0.0285;//k=0.0285 at mean temperature of (Tb+Tb2/2) i.e. 56.7 degree celcius

end Ex5_6;

//===================================================================================
//Remarks
//L=2m is not substituted in the Nusselt number equation 
