//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 5:Convection
//Example :5.8 page 220
//Topic:Current passing through horizontal wire
//===================================================================================

model Ex5_8
extends Modelica.Constants;
extends Modelica.Math;

//=================================
//parameter section

parameter Real L(unit="m")=0.5"Length of the wire";
parameter Real D(unit="mm")=0.1"Diameter of the wire";
parameter Real k(unit="W/mK")=0.03"Thermal conductivity at mean film temperature";
parameter Real Nu(unit="")=0.4"Nusselt number";
parameter Real Tw(unit="K")=400"Temperature of the wire";
parameter Real Ta(unit="K")=300"Atmospheric temperature";
parameter Real R(unit="Ohm/m")=0.012"Resistance of the wire";

//=================================
//Variable section

Real h(unit="W/m^2K")"Heat transfer coefficient";
Real Q(unit="W")"Heat loss from the wire";
Real I(unit="A")"Current in the wire";

//=================================
//Equation section

equation

h=(Nu*k)/(D*1e-3);
Q=h*pi*D*1e-3*L*(Tw-Ta);
I=sqrt(Q/(R*L));

end Ex5_8;
