//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 6:Incompressible Viscous Flow : A Brief Review
//Example :6.1 page 247
//Topic:Oil flows between two fixed plates
//===================================================================================

package Ex6_1

//===================================================================================

model Ex6_1_a

//=================================
//parameter section 

parameter Real gs(unit="")=0.9"Specific gravity of oil";
parameter Real Mu(unit="Pas")=0.1"Viscosity of the oil";
parameter Real b(unit="mm")=10"Distance between the fixed plates";
parameter Real Uavg(unit="m/s")=1.6"Average velcity of flow";

//=================================
//Variable section

Real Umax(unit="m/s")"Maximum velocity";

//=================================
//Equation section

equation

Umax=(3/2)*Uavg;

end Ex6_1_a;

//===================================================================================

model Ex6_1_b
extends Ex6_1_a;

//=================================
//Variable section

Real t(unit="N/m^2")"Shear stress at the plate";

//=================================
//Equation section

equation

t=2*Mu*Umax/((b*1e-3)/2);

end Ex6_1_b;
//=================================================================================== 

model Ex6_1_c
extends Ex6_1_a;

//=================================
//Variable section

Real P(unit="N/m^3")"Pressure drop gradient";
Real t1(unit="N/m^2")"Shear stress at lower plate";
Real t2(unit="N/m^2")"Shear stress at upper plate";
Real DP(unit="N/m^2")"Pressure drop over a distance of 2m";

//=================================
//Equation section

equation

P=(-3*Mu*Uavg)/((b*1e-3/2)^2);
t1=0.003*P;
t2=-0.003*P;
DP=(-P)*2;

end Ex6_1_c;

//===================================================================================
end Ex6_1;

//Remarks
//Shear stress at lower and upper plate at Part c is -57.6 and 57.6 respectivley
//Part d is not given as a subdivision in the question
