//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 6:Incompressible Viscous Flow : A Brief Review
//Example :6.3 page 249
//Topic:Conservation Equations
//===================================================================================

model Ex6_3
extends Modelica.Constants;

//=================================
//parameter section

parameter Real gs(unit="")=0.9"Specific gravity of oil";
parameter Real P(unit="kN/m^2")=10"Pressure difference";
parameter Real z(unit="m")=5"Length of the pipe";
parameter Real D(unit="mm")=50"Diameter of the pipe";
parameter Real Ms(unit="kg/s")=3"Mass flow rate";

//=================================
//Variable section

Real Q(unit="m^3/s")"Volumetric flow rate";
Real Mu(unit="kg/ms")"Viscosity of the oil";

//=================================
//Equation section

equation

Q=Ms/(gs*1e3);
Mu=(pi*((D*1e-3)^4)*P*1e3)/(128*Q*z);

end Ex6_3;
