//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.10 page 341
//Topic:The tube heated length
//===================================================================================

model Ex7_10

//=================================
//parameter section

parameter Real Tbi(unit="degree celcius")=75"Temperature of air at inlet";
parameter Real Tbo(unit="degree celcius")=125"Temperature of air at outlet";
parameter Real u(unit="m/s")=2"Average velocity of air";
parameter Real x(unit="m")=0.04"tube heated length";
parameter Real d(unit="mm")=4"Internal dia of tube";
parameter Real Nu(unit="")=4.7"Nusselt number at fully devoloped flow";
parameter Real Re(unit="")=349"Reynolds number";
parameter Real qw1(unit="W/m^2")=96"Surface heat flux when tube length is 1m";
//properties of air at mean temperature
parameter Real rho(unit="kg/m^3")=0.95"Density of air";
parameter Real Cp(unit="kJ/kgK")=1.01"Specific heat of air";
parameter Real Mu(unit="kg/ms")=2.18e-5"Viscosity of air";
parameter Real k(unit="W/mK")=0.03"Thermal conductivity of air";
parameter Real Pr(unit="")=0.7"Prandtl number";

//=================================
//Variable section

Real Gr(unit="")"inverse Graetz number(1/Gr)";
Real hL(unit="W/m^2K")"heat transfer coefficient";
Real qw(unit="W/m^2")"surface heat flux";
Real Twe(unit="degree celcius")"Surface temperature at exit";

//=================================
//Equation section

equation

Gr=(x/(d*1e-3))*(1/(Re*Pr));
hL=(Nu*k)/(d*1e-3);
qw=qw1*(1/x);   
Twe=Tbo+(qw/hL);


end Ex7_10;
