//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.2 page 317
//Topic:Atmospheric air flows over a plate
//===================================================================================

package Ex7_2

//===================================================================================

model Ex7_2_a

//=================================
//parameter section

parameter Real To(unit="K")=300"Atmospheric Temperature of air";
parameter Real Tw(unit="K")=400"Temperature of the plate";
parameter Real L(unit="m")=2"Length of the plate";
parameter Real Tf(unit="K")=350"Film temperature";
parameter Real u(unit="m/s")=30"Velocity of the stream";
//Properties of air at film temperature
parameter Real Rex(unit="")=5e5"Reynolds number";
parameter Real k(unit="W/mK")=0.026"Thermal conductivity of air";
parameter Real v(unit="m^2/s")=16.5e-6"Kinematic viscosity";
parameter Real Pr(unit="")=0.705"Prandtl number";

//=================================
//Variable section

Real x(unit="m")"Location were transition occurs";
Real Nux(unit="")"Nusselt number at x";
Real hx(unit="W/m^2K")"Heat transfer coefficient at the region";

//=================================
//Equation section

equation

x=(v*Rex)/u;
Nux=0.664*(Rex^0.5)*(Pr^(1/3));
hx=(k*Nux)/x;

end Ex7_2_a;

//===================================================================================

model Ex7_2_b
extends Ex7_2_a;

//=================================
//Variable section

Real ReL(unit="")"Reynolds number at length L";
Real hL(unit="W/m^2K")"Heat transfer coefficient at L";

//=================================
//Equation section 

equation

ReL=(u*L)/v;
hL=(k/L)*(0.037*(ReL^(4/5))-871)*(Pr^(1/3));

end Ex7_2_b;

//===================================================================================

model Ex7_2_c
extends Ex7_2_a;
extends Ex7_2_b;

//=================================
//Variable section

Real Q(unit="kW")"Heat transfer rate per unit width";

//=================================
//Equation section

equation

Q=hL*L*(Tw-To)*1e-3;

end Ex7_2_c;

//===================================================================================

end Ex7_2;
