//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.3 page 318
//Topic:Air flows with constant temperature
//===================================================================================

package Ex7_3

//===================================================================================

model Ex7_3_a

//=================================
//parameter section

parameter Real To(unit="degree celcius")=20"Temperature of air";
parameter Real Tp(unit="degree celcius")=140"Temperature of the plate";
parameter Real L1(unit="m")=5"Length of the plate";
parameter Real L2(unit="m")=1"width of the plate";
parameter Real Tf(unit="degree celcius")=80"Film temperature";
parameter Real u(unit="m/s")=5"Velocity with which the air flows";
//Properties of air at film temperature
parameter Real k(unit="W/mK")=0.03"Thermal conductivity of air";
parameter Real v(unit="m^2/s")=2e-5"Kinematic viscosity";
parameter Real Pr(unit="")=0.706"Prandtl number";

//=================================
//Variable section

Real ReL1(unit="")"Reynolds number at L1";
Real hL1(unit="W/m^2K")"Heat transfer coefficient at L1";
Real Q1(unit="kW")"Rate of heat transfer";

//=================================
//Equation section

equation

ReL1=(u*L1)/v;
hL1=(k/L1)*(0.037*(ReL1^(4/5))-871)*(Pr^(1/3));
Q1=L1*L2*hL1*(Tp-To)*1e-3;

end Ex7_3_a;

//===================================================================================

model Ex7_3_b
extends Ex7_3_a;

//=================================
//Variable section

Real ReL2(unit="")"Reynolds number at L2";
Real hL2(unit="W/m^2K")"Heat transfer coefficient at L2";
Real Q2(unit="kW")"Rate of heat transfer at L2";

//=================================
//Equation section

equation

ReL2=(u*L2)/v;
hL2=(k/L2)*0.664*(ReL2^0.5)*(Pr^(1/3));
Q2=L1*L2*hL2*(Tp-To)*1e-3;

end Ex7_3_b;

//===================================================================================

end Ex7_3;
