//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.4 page 319
//Topic:Castor oil flows over a heated plate
//===================================================================================

package Ex7_4

//===================================================================================

model Ex7_4_a

//=================================
//parameter section

parameter Real To(unit="degree celcius")=36"Temperature of castor oil";
parameter Real Tp(unit="degree celcius")=96"Temperature of the plate";
parameter Real L(unit="m")=6"Length of the plate";
parameter Real B(unit="m")=1"width of the plate";
parameter Real Tf(unit="degree celcius")=66"Film temperature";
parameter Real u(unit="m/s")=0.06"Velocity with which the oil flows";
//Properties of castor oil at film temperature
parameter Real k(unit="W/mK")=0.21"Thermal conductivity of oil";
parameter Real v(unit="m^2/s")=6e-5"Kinematic viscosity";
parameter Real a(unit="m^2/s")=7.22e-8"Thermal diffusivity";

//=================================
//Variable section

Real ReL(unit="")"Reynolds number ";
Real t(unit="m")"thickness of plate";
Real Pr(unit="")"Prandtl number";
Real Th(unit="m")"Thickness at end of the plate";

//=================================
//Equation section

equation

ReL=(u*L)/v;
t=(5*L)/(ReL^0.5);
Pr=v/a;
Th=t/(Pr^(1/3));

end Ex7_4_a;

//===================================================================================

model Ex7_4_b
extends Ex7_4_a;

//=================================
//Variable section

Real NuL(unit="")"Nusselt number";
Real hL(unit="W/m^2K")"Heat transfer coefficient and end of the plate";

//=================================
//Equation section

equation

NuL=0.339*(ReL^0.5)*(Pr^(1/3));
hL=(k/L)*NuL;

end Ex7_4_b;

//===================================================================================

model Ex7_4_c
extends Ex7_4_a;
extends Ex7_4_b;

//=================================
//Variable section

Real H(unit="W/m^2K")"Heat transfer coefficient for entire plate";
Real Q(unit="kW")"Rate of heat transfer";

//=================================
//Equation section

equation

H=2*hL;
Q=L*B*H*(Tp-To)*1e-3;

end Ex7_4_c;

//===================================================================================

end Ex7_4;

//Remarks 
//Thickness at the end of the plate is 0.041(calculated value) and not 0.41(book answer)
