//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.5 page 320
//Topic:Convective heat transfer in external flows
//===================================================================================

model Ex7_5

//=================================
//parameter section

parameter Real To(unit="degree celcius")=25"Temperature of air";
parameter Real Tw(unit="degree celcius")=225"Temperature of the plate";
parameter Real L(unit="mm")=40"Length of the plate";
parameter Real B(unit="m")=1"Width of the plate";
parameter Real t(unit="m")=10"Thickness of the plate";
parameter Real Tf(unit="degree celcius")=125"Film temperature";
parameter Real u(unit="m/s")=30"Velocity with which the air flows";
parameter Real L1(unit="mm")=800"Distance from the leading edge";
//Properties of air at film temperature
parameter Real k(unit="W/mK")=0.031"Thermal conductivity of air";
parameter Real v(unit="m^2/s")=22e-6"Kinematic viscosity";
parameter Real Pr(unit="")=0.7"Prandtl number";

//=================================
//Variable section

Real ReL(unit="")"Reynolds number";
Real L2(unit="m")"Total length from centre of the plate to L1";
Real hL(unit="W/m^2K")"Heat transfer coefficient at L2";
Real qm(unit="MW/m^3")"Power generated in the module";

//=================================
//Equation section

equation

L2=((L/2)+L1)*1e-3;
ReL=(u*L2)/v;
hL=(k/L2)*(0.0296*(ReL^(4/5))*(Pr^(1/3)));
qm=((hL*(L*1e-3)*B*(Tw-To))/((L*1e-3)*(t*1e-3)*B))*1e-6;

end Ex7_5;
