//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.7 page 321
//Topic:Fine wire is placed in air stream
//===================================================================================

model Ex7_7

//=================================
//parameter section

parameter Real D(unit="mm")=0.04"Diameter of the wire";
parameter Real To(unit="degree celcius")=25"Temperature of the air stream";
parameter Real u(unit="m/s")=60"Velocity of stream";
parameter Real Tw(unit="degree celcius")=50"Temperature of the surface";
//properties of air at film temperature of 37.5 degree celcius
parameter Real k(unit="W/mK")=0.027"Thermal conductivity ";
parameter Real v(unit="m^2/s")=17e-6"Kinematic viscosity";
parameter Real Pr(unit="")=0.71"Prandtl number";

//=================================
//Variable section

Real Re(unit="")"Reynolds number";
Real NuD1(unit="")"Nusselt number (1)";
Real h1(unit="W/m^2K")"Heat transfer coefficient (1)";
Real q1(unit="W/m")"Heat transfer per unit length (1)";
Real NuD2(unit="")"Nusselt number (2)";
Real h2(unit="W/m^2K")"Heat transfer coefficient (2)";
Real q2(unit="W/m")"Heat transfer per unit length (2)";

//=================================
//Equation section

equation

Re=(u*D*1e-3)/v;
NuD1=0.683*(Re^0.466)*(Pr^(1/3));
h1=(NuD1*k)/(D*1e-3);
q1=3.14*(D*1e-3)*h1*(Tw-To);
NuD2=0.3+(((0.62*(Re^0.5)*(Pr^(1/3)))/(((1+((0.4/Pr)^(2/3)))^(1/4))))*((1+((Re/2.82e5)^(5/8)))^(4/5)));
h2=(NuD2*k)/(D*1e-3);
q2=3.14*(D*1e-3)*h2*(Tw-To);

end Ex7_7;
