//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.8 page 340
//Topic:Hydrodynamic and thermal entry length
//===================================================================================

model Ex7_8

//=================================
//parameter section

parameter Real u(unit="mm/s")=4"Velocity of mercury and oil";
parameter Real d(unit="mm")=25"Diameter of the smooth tube";
//properties of fluid at film temperature (80 degree celcius)
parameter Real vHg(unit="m^2/s")=1e-7"Kinematic viscosity of mercury";
parameter Real voil(unit="m^2/s")=6.5e-6"Kinematic viscosity of oil";
parameter Real PrHg(unit="")=0.019"Prandtl number of mercury";
parameter Real Proil(unit="")=85"Prandtl number of oil";

//=================================
//Variable section

Real ReHg(unit="")"Reynolds number of mercury";
Real Reoil(unit="")"Reynolds number of oil";
Real LeHg(unit="m")"Hydrodynamic entry length of mercury";
Real Leoil(unit="m")"Hydrodynamic entry length of oil";
Real LtHg(unit="m")"Thermal entry length of mercury";
Real Ltoil(unit="m")"Thermal entry length of oil";

//=================================
//Equation section

equation

ReHg=((d*1e-3)*(u*1e-3))/vHg;
Reoil=((d*1e-3)*(u*1e-3))/voil;
LeHg=0.05*ReHg*(d*1e-3);
Leoil=0.05*Reoil*(d*1e-3);
LtHg=0.05*ReHg*PrHg*(d*1e-3);
Ltoil=0.05*Reoil*Proil*(d*1e-3);

end Ex7_8;
