//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 8:Principles of free convection
//Example :8.1 page 371
//Topic:Water heated by a vertical plate
//===================================================================================

model Ex8_1
extends Modelica.Constants;

//=================================
//parameter section

parameter Real l(unit="mm")=200"Length of the flat plate";
parameter Real b(unit="mm")=200"Breadth of the plate";
parameter Real Tw(unit="degree celcius")=60"Temperature of the plate";
parameter Real To(unit="degree celcius")=20"Temperature of water";
//Properties at mean film temperature
parameter Real k(unit="W/mK")=0.628"Thermal conducivity ";
parameter Real B(unit="K^-1")=3e-4"";
parameter Real v(unit="m^2/s")=0.658e-6"kinematic viscosity";
parameter Real rho(unit="kg/m^3")=994.59"Density of water";
parameter Real Pr(unit="")=4.34"Prandtl number";
parameter Real Co(unit="")=0.1"Constant";
parameter Real n(unit="")=0.333"";

//=================================
//Variable section

Real L(unit="m")"Length of the plate";
Real Br(unit="m")"Breadth of the plate";
Real GrL(unit="")"Grashoff Number";
Real RaL(unit="")"Reynolds number";
Real hL(unit="W/m^2K")"Heat transfer coefficient";
Real q(unit="kW")"Rate of heat transfer"; 
//=================================
//Equation section

equation

L=l*1e-3;
Br=b*1e-3;
GrL=(g_n*B*(Tw-To)*(L^3))/(v^2);
RaL=GrL*Pr;
hL=(k*Co*(RaL^n))/L;
q=hL*L*Br*(Tw-To)*1e-3;

end Ex8_1;
