//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 8:Principles of free convection
//Example :8.2 page 371
//Topic:Thin plates to be cooled
//===================================================================================

model Ex8_2
extends Modelica.Constants;

//=================================
//parameter section

parameter Real l(unit="mm")=90"Length of the flat plate";
parameter Real x(unit="mm")=9"Spacing between the plates";
parameter Real Tw(unit="degree celcius")=60"Temperature of the plate";
parameter Real To(unit="degree celcius")=20"Temperature of water";
//Properties at mean film temperature
parameter Real k(unit="W/mK")=0.628"Thermal conducivity ";
parameter Real B(unit="K^-1")=3e-4"";
parameter Real v(unit="m^2/s")=0.658e-6"kinematic viscosity";
parameter Real rho(unit="kg/m^3")=994.59"Density of water";
parameter Real Pr(unit="")=4.34"Prandtl number";

//=================================
//Variable section

Real L(unit="m")"Length of the plate";
Real X(unit="m")"Spacing between the plates";
Real GrL(unit="")"Grashoff Number";
Real RaL(unit="")"Reynolds number";
Real d(unit="m")"Thickness of the boundry layer";
Real dmin(unit="mm")"Minimum spacing";

//=================================
//Equation section

equation

L=l*1e-3;
X=x*1e-3;
GrL=(g_n*B*(Tw-To)*(L^3))/(v^2);
RaL=GrL*Pr;
d=(L*3.93*((0.952+Pr)^(1/4)))/((Pr^0.5)*(GrL^(1/4)));
dmin=2*d*1e3;

end Ex8_2;
