//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 8:Principles of free convection
//Example :8.3 page 372
//Topic:Maximum velocity in the boundary layer
//===================================================================================

model Ex8_3
extends Modelica.Constants;

//=================================
//parameter section

parameter Real x(unit="m")=0.8"Boundry Layer";
parameter Real b(unit="m")=2.5"Width of the wall";
parameter Real H(unit="m")=2"height of the wall";
parameter Real Tw(unit="degree celcius")=56"Temperature of the plate";
parameter Real To(unit="degree celcius")=4"Temperature of nitrogen";
//Properties at mean film temperature
parameter Real k(unit="W/mK")=0.026"Thermal conducivity ";
parameter Real rho(unit="kg/m^3")=1.142"Density of nitrogen";
parameter Real B(unit="K^-1")=3.3e-3"";
parameter Real v(unit="m^2/s")=15.63e-6"kinematic viscosity";
parameter Real Pr(unit="")=0.713"Prandtl number";

//=================================
//Variable section

Real Gr(unit="")"Grashoff number";
Real d(unit="m")"Boundry layer thickness";
Real Ux(unit="m/s")"Velocity at x";
Real Umax(unit="m/s")"Maximum velocity";
Real y(unit="m")"Edge of the boundry";
Real m(unit="kg/s")"Mass flow rate of nitrogen";

//=================================
//Equation section

equation

Gr=(g_n*B*(Tw-To)*(x^3))/(v^2);
d=(x*3.93*((0.952+Pr)^(1/4)))/((Pr^0.5)*(Gr^(1/4)));
Ux=(g_n*B*(d^2)*(Tw-To))/(4*v);
Umax=(Ux/d)*(y-(116*(y^2))+(3341*(y^3)));
0=1-(232*y)+(10023*(y^2));
m=rho*b*(Ux/d)*(((d^2)/2)-(116*((d^3)/3))+(3341*((d^4)/4)));

end Ex8_3;

//==============================================================================
//Remarks
//Umax answer is miscalculated as (Ux/d)*y*(1-57.8(y^2)) instead of (Ux/d)*y*((1-57.8y)^2)
 
