//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 8:Principles of free convection
//Example :8.5 page 374
//Topic:Square plate in room
//===================================================================================

package Ex8_5

//=========================================================================

model Ex8_5_a
extends Modelica.Constants;

//=================================
//parameter section

parameter Real b(unit="m")=0.5"Width of the plate";
parameter Real L(unit="m")=0.5"Length of the plate";
parameter Real Tw(unit="degree celcius")=74"Temperature of the plate";
parameter Real To(unit="degree celcius")=30"Temperature of air";
//Properties at mean film temperature
parameter Real k(unit="W/mK")=0.028"Thermal conducivity ";
parameter Real v(unit="m^2/s")=1.815e-5"kinematic viscosity";
parameter Real Pr(unit="")=0.71"Prandtl number";
parameter Real Co(unit="")=0.59"Constant";
parameter Real n(unit="")=0.25"Constant";

//=================================
//Variable section

Real Tf(unit="degree celcius")"Film Temperature";
Real B(unit="K^-1")"";
Real GrL(unit="")"Grashoff number";
Real RaL(unit="")"Reynolds number";
Real NuL1(unit="")"Nusselt number";
Real NuL2(unit="")"Nusselt number";
Real hL1(unit="W/m^2K")"Heat transfer coeffient";
Real hL2(unit="W/m^2K")"Heat transfer coeffient";
Real Q1(unit="W")"Rate of heat transfer";
Real Q2(unit="W")"Rate of heat transfer";

//=================================
//Equation section

equation

Tf=(Tw+To)/2;
B=1/(273+Tf);
GrL=(g_n*B*(Tw-To)*(L^3))/(v^2);
RaL=GrL*Pr;
NuL1=(4*0.508*(Pr^0.5)*(GrL^0.25))/(3*((0.952+Pr)^0.25));
hL1=(NuL1*k)/L;
Q1=hL1*L*b*(Tw-To);
NuL2=Co*(RaL^n);
hL2=(NuL2*k)/L;
Q2=hL2*L*b*(Tw-To);

end Ex8_5_a;
//=========================================================================

model Ex8_5_b
extends Ex8_5_a;

//=================================
//parameter section

parameter Real Co1(unit="")=0.54"Constant";
parameter Real n1(unit="")=0.25"Constant";

//=================================
//Variable section

Real A(unit="m^2")"Area of the plate";
Real P(unit="m")"Perimeter of the plate";
Real L1(unit="m")"Charecterstic Length";
Real RaL1(unit="")"Reynolds number";
Real NuL3(unit="")"Nusselt number";
Real hL3(unit="W/m^2K")"Heat transfer coefficient";
Real Q3(unit="W")"Heat transfer rate";

//=================================
//Equation section

equation

A=L*b;
P=4*L;
L1=(A/P);
RaL1=RaL*((L1/L)^3);
NuL3=Co1*(RaL1^n1);
hL3=(NuL3*k)/L1;
Q3=hL3*L*b*(Tw-To);

end Ex8_5_b;

//=========================================================================

model Ex8_5_c
extends Ex8_5_a;
extends Ex8_5_b;

//=================================
//Variable section

Real NuL4(unit="")"Nusselt number when hot surface faces down";
Real hL4(unit="W/m^2K")"Heat transfer coefficient";
Real Q4(unit="W")"Heat transfer rate";

//=================================
//Equation section

equation

NuL4=0.27*(RaL1^0.25);
hL4=(NuL4*k)/L1;
Q4=hL4*L*b*(Tw-To);

end Ex8_5_c;

//=========================================================================

end Ex8_5;
