//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 8:Principles of free convection
//Example :8.7 page 377
//Topic:Pressurized long hot water pipe
//===================================================================================

model Ex8_7
extends Modelica.Constants;

//=================================
//parameter section

parameter Real d(unit="mm")=200"Diameter of the pipe";
parameter Real L(unit="m")=1"Length of the pipe";
parameter Real Tw(unit="degree celcius")=130"Temperature of pipe";
parameter Real To(unit="degree celcius")=25"Temperature of ambient air";
//Properties at mean film temperature
parameter Real k(unit="W/mK")=0.03"Thermal conducivity ";
parameter Real v(unit="m^2/s")=21e-6"kinematic viscosity";
parameter Real Pr(unit="")=0.7"Prandtl number";

//=================================
//Variable section

Real D(unit="m")"Diameter of the pipe";
Real Tf(unit="degree celcius")"Film Temperature";
Real B(unit="K^-1")"";
Real GrD(unit="")"Grashoff number";
Real RaD(unit="")"Reynolds number";
Real NuD(unit="")"Nusselt number";
Real hD(unit="W/m^2K")"Heat transfer coefficient";
Real q(unit="W")"Heat loss per length";

//=================================
//Equation section

equation

D=d*1e-3;
Tf=(Tw-To)/2;
B=1/(Tf+273);
GrD=(g_n*B*(Tw-To)*(D^3))/(v^2);
RaD=GrD*Pr;
NuD=(0.6+((0.387*(RaD^(1/6)))/((1+((0.559/Pr)^(9/16)))^(8/27))))^2;
hD=(NuD*k)/D;
q=hD*pi*D*(Tw-To);

end Ex8_7;
