//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 9:Heat transfer in Condensation and boiling
//Example :9.5 page 407
//Topic:Nickel wire submerged in water
//===================================================================================

model Ex9_5
extends Modelica.Constants;

//=================================
//parameter section

parameter Real L(unit="m")=0.1"Length of the nickel wire";
parameter Real d(unit="mm")=1"Diameter of the wire";
parameter Real I(unit="A")=150"Current required to maintain the temperature";
parameter Real E(unit="V")=2.2"Voltage required to maintain the temperature";
parameter Real Tg(unit="degree celcius")=110"Temperature of the wire";
parameter Real Tw(unit="degree celcius")=100"Temperature of the water at one atm";

//=================================
//Variable section

Real h1(unit="W/m^2K")"Heat transfer coefficient";

//=================================
//Equation section

equation

h1=(E*I)/(pi*L*d*(Tg-Tw)*1e-3);

end Ex9_5;

//==============================================================================
//Remarks
//Unit of heat transfer coefficient is wrong.
