model Ex10_1 
import Modelica.Constants.*;
parameter Real Ro(unit = "nm") = 0.281"equilibrium distance between ions";
parameter Real alpha= 1.748"Madelung constant";
parameter Real n = 9;
parameter Real e(unit = "C") = 1.6*(10^(-19))"charge of an electron";
parameter Real Po(unit = "F/m") = 8.85*(10^(-12))"Permittivity of free space";
Real K(unit = "N.m^2/C^2")"constant";
Real Uo(unit = "eV")"Potential energy per ion pair";
Real E1(unit = "eV")"Ionisation energy for Na";
Real E2(unit = "eV")"electron affinity of Cl";
Real E(unit = "eV")"Electron transfer energy";
Real Ecohesive(unit = "eV")"per electron pair";
Real Ecohesiveach(unit = "eV")"for each ion";
equation
K=1/(4*(pi)*Po);
Uo= -(K*alpha*(e^2)*(1-(1/n)))/(Ro*(10^(-9)))/e;
E1= 5.14;
E2= -3.61;
E= E1+E2;
Ecohesive = (Uo +E);
Ecohesiveach= Ecohesive/2;
end Ex10_1;
