model Ex11_6 
parameter Real Z= 30"proton number";
parameter Real N=34"Neutron number"; 
parameter Real Mh(unit = "u") = 1.007825"Mass of H1 atom";
parameter Real Mn(unit = "u") = 1.008665"Mass of neutron";
parameter Real Mzinc(unit = "u") = 63.929"atomic mass of zinc";
Real Ebinding(unit = "MeV");
Real a1(unit = "MeV");
Real a2(unit = "MeV");
Real a3(unit = "MeV");
Real a4(unit = "MeV");
Real a5(unit = "MeV");
Real A;
Real E2(unit = "MeV");
equation
Ebinding= ((Z*Mh)+(N*Mn)-Mzinc)*931.49;
//Using semiempirical formula, Eqn 11.18, Page  407
a1= 14.1;
a2= 13.0;
a3= 0.595;
a4= 19.0;
a5= 33.5;
A= Z+N; 
E2= ((a1*A)-(a2*(A^(2/3)))-(a3*Z*(Z-1)/(A^(1/3)))-(a4*((A-2*Z)^2)/A)+(a5/(A^(3/4))));
end Ex11_6;
