model Ex3_2
parameter Real a(unit = "m") =10^(-15)"de Broglie wavelength";
parameter Real Eo(unit = "GeV") = 0.938"proton rest energy";
parameter Real h(unit = "eV.s") = 4.136*(10^(-15))"Planck's constant";
parameter Real c(unit = "m/s") = 3*(10^8)"velocity of light";//considered 2.998 in book
Real pc(unit = "Gev")"Photon's energy";
Real E(unit = "GeV")"total energy";
Real KE (unit = "MeV")"Kinetic energy";
equation
pc= (h*c)/a*(10^(-9));    
//pc>E0, relativistic calculation
E= sqrt((Eo^2) + (pc^2));
KE = (E-Eo)*1000;
//Slight diffrence in values due to approximation in book
end Ex3_2;
