model Ex4_1
import Modelica.Constants.*;
parameter Real E(unit = "eV") = -13.6"Energy required to separate electron and proton";
parameter Real e(unit = "C") = 1.6*(10^(-19))"charge of an electron";
Real E1"converting to J";
Real Po(unit = "F/m")"Permittivity of free space";
Real r(unit = "m")"radius";
Real m(unit = "kg")"mass of electron";
Real v(unit = "m/s")"velocity";
equation
E1= E*e;
Po= 8.85*(10^(-12));
r= - e^2/(8*(pi)*Po*E1);
m= 9.1*(10^(-31));
v=e/sqrt(4*pi*Po*m*r);
//Since v <<c , we can ignore special relativity when considering hydrogen atom.
end Ex4_1;
