model Ex7_3
import Modelica.Constants.*;
parameter Real n= 2"for 2p state";
parameter Real Ao(unit = "m") = 5.29*(10^(-11))"Bohr's orbit for n=1";
Real r(unit = "m")"orbital radius";
Real f(unit = "Hz")"frequency of revolution";
Real Mo(unit = "T.m/A")"Magnetic constant";
Real e(unit = "C")"charge of an electron";
Real B(unit = "T")"Magnetic field";
Real Mb(unit = "J/T")"Bohr Magneton";
Real Um(unit = "J")"Magnetic energy";
Real Um1(unit = "eV")"converting to eV";
equation
r= (n^2)*Ao;
f= 8.4*(10^14);
Mo= 4*(pi)*(10^(-7));
e= 1.6*(10^(-19));
B= (Mo*f*e)/(2*r);
Mb= 9.27*(10^(-24));
Um= Mb*B;
Um1= Um/e;
 

end Ex7_3;
