model Ex8_1 
//Part (a)
import Modelica.Constants.*;
parameter Real r(unit = "nm") = 0.113"bond length";
parameter Real Mc(unit = "kg") = 1.99*(10^(-26))"mass of C12";
parameter Real Mo(unit = "kg") = 2.66*(10^(-26))"mass of O16";
Real Mco(unit = "kg")"mass of CO";
Real I(unit = "kg.m^2")"moment of inertia";
Real J"lowest rotational state";
Real hbar(unit = "J.s")"reduced Planck's constant";
Real E1(unit = "J")"energy corresponding to state J=1";
Real e(unit = "C")"charge of an electron";
Real E2(unit = "eV")"converting to eV";
Real w(unit = "rad/s")"angular velocity";
equation
Mco= (Mc*Mo)/(Mc+Mo);
I= Mco*((r*(10^(-9)))^2);
J=1;
hbar= h/(2*(pi));//h(unit = "J.s")"Planck's constant";
E1= (J*(J+1)*(hbar^2))/(2*I);
e= 1.6*(10^(-19));
E2= E1/e;
//Part(b)
w= sqrt((2*E1)/(I));
//Ans given in book is wrong for b part 
end Ex8_1;
