model Ex1_4
parameter Real StartingAge(unit = "yr")= 20"starting age for both Dick and Jane";
parameter Real c(unit = "m/s") = 3*(10^8)"velocity of light";
Real v(unit = "m/s")"rate of separation of Dick and Jane";
Real t0(unit = "yr")"interval for emission of signals";
Real t1(unit = "yr")"interval for reception of signals on outward journey";
Real t2(unit = "yr")"interval for reception of signals on return trip";
Real Tout1(unit = "yr")"duration of outward trip";
Real Tin1(unit = "yr")"duration of return trip";
Real JaneAge(unit = "yr")"Jane's age according to Dick";
Real Tout2(unit = "yr")"duration of outward trip";
Real d(unit = "yr")"delay in transmission of signal to Jane";
Real Tin2(unit = "yr")"duration of return trip";
Real DickAge(unit = "yr")"Dick's age according to Jane";
equation
v= 0.8*c;
t0= 1;
t1= t0*(sqrt((1+v/c)/(1-v/c)));
t2= t0*(sqrt((1-v/c)/(1+v/c)));
Tout1= 15;
Tin1= 15;
JaneAge= StartingAge+(Tout1/t1)+(Tin1/t2);
Tout2= 25;
d= 20;
Tin2= 5;
DickAge= StartingAge+((Tout2+d)/t1)+(Tin2/t2);
end Ex1_4;
