model Ex12_10
parameter Real Thalf(unit = "day") = 2.69"half life of gold";
Real Lambda(unit = "s^(-1)")"decay constant";
Real R(unit = "Ci")"required activity";
Real dN(unit ="atoms");
Real Wgold(unit = "mg")"mass of foil";
Real u(unit = "kg")"atomic mass unit";
Real Mgold(unit = "u");
Real n2(unit="atoms");
Real phi(unit = "neutrons/m^2")"flux";
Real CrossSection(unit = "m^2");
Real dT(unit = "s");
equation
Lambda= 0.693/(Thalf*86400);
R= 2*10^(-4);
dN= R*(3.70*10^(10))/Lambda;
Wgold= 10;
u= 1.66*(10^(-27));
Mgold= 197;
n2= Wgold*10^(-6)/(Mgold*u);
phi= 2*10^(16);
CrossSection= 99*10^(-28);
dT= dN/(phi*n2*CrossSection);
//Ans Varies slightly due to approximation 
end Ex12_10;
