model Ex12_8
import Modelica.Constants.*;
parameter Real CrossSection= 2*(10^4)" capture cross section of Cadmium-113";
Real CrossSection1" converting to m^2";
Real Mcadmium(unit = "u")"mean atomic mass of cadmium";
Real density(unit = "kg/m^3")"density of cadmium sheet used";
Real t(unit = "mm")"hickness of sheet used";
Real t1"converting to m";
Real p"percent of Cadmium-113 in natural cadmium";
Real u(unit = "kg")"atomic mass unit";
Real n(unit = "atoms/m^3")"number of atoms";
Real Fabsorbed"absorbed fraction";
Real t2(unit = "m")"required thickness";
Real t21"converting to mm";
equation
CrossSection1= CrossSection*(10^(-28));
Mcadmium= 112;
density= 8.64*(10^3);
//Part (a)
t= 0.1;
t1= t*10^(-3);
p= 12;
u= 1.66*(10^(-27));
n= (p/100)*density/(Mcadmium*u);
Fabsorbed= 1- ((e)^((-n)*(CrossSection1)*(t1))); 
//Part (b)
t2= (-(log(0.01)))/(n*CrossSection1);
t21= t2*10^(3);
end Ex12_8;
