package Ex2_4
  model Ex2_4_a
    import Modelica.Math.*;
    import Modelica.Constants.*;
    parameter Real l(unit = "pm") = 10 "wavelength of x-ray";
    parameter Real r(unit = "radians") = 45*pi/180 "angle of scattered articles";
    parameter Real lc(unit = "pm") = 2.426 "Compton wavelength for electron";
    Real l2(unit = "pm") "wavelength of x-ray scattered through 45 degree";
  equation
    l2 = l + lc * (1 - cos(r));
  end Ex2_4_a;









  model Ex2_4_b
  Real lmax(unit = "pm");//wavelength is maximum when (1- cos(r)=2
  parameter Real l(unit = "pm") = 10 "wavelength of x-ray";
  parameter Real lc(unit = "pm") = 2.426 "Compton wavelength for electron";
  equation
  lmax= l+(lc*2);
  end Ex2_4_b;




  model Ex2_4_c
    Real h(unit = "J.s")"Planck's constant";
    Real c(unit = "m/s")"velocity of light";
    Real KEmax(unit="J");
    parameter Real l(unit = "pm") = 10 "wavelength of x-ray";
    parameter Real lmax(unit = "pm") =14.9;
    equation
  h= 6.63*(10^(-34));
  c= 3*10^8;
  KEmax= ((h*c)*((1/l)-(1/lmax)))/10^(-12);
  
  end Ex2_4_c;










end Ex2_4;
