package Ex5_6
  model  Ex5_6_a
    import Modelica.Math.*;
    parameter Real E1(unit = "eV") = 1.0 "energy of first electron";
    parameter Real E2(unit = "eV") = 2.0 "energy of second electron";
    parameter Real Eb(unit = "eV") = 10.0 "height of barrier";
    parameter Real Wb(unit = "m") = 0.50 * 10 ^ (-9) "width of barrier";
    Real hbar(unit = "J.s") "reduced Planck's conctaant";
    Real Me(unit = "kg") "mass of electron";
    Real e1(unit = "J/eV") "charge of an electron";
    Real k1(unit = "m^(-1)")"for first electron";
    Real k2(unit = "m^(-1)") "for second electron";
    Real T1;
    Real T2;
    
  equation
    hbar = 1.054 * 10 ^ (-34);
    Me = 9.1 * 10 ^ (-31);
    e1 = 1.6 * 10 ^ (-19);
    k1= sqrt(2*Me*(Eb-E1)*e1)/hbar;
    k2= sqrt(2*Me*(Eb-E2)*e1)/hbar;
    T1= exp((-2)*k1*Wb); //transmission probability for first electron
    T2= exp((-2)*k2*Wb); //for second electron
  

  end  Ex5_6_a;




  model  Ex5_6_b
  import Modelica.Math.*;
  parameter Real E1(unit = "eV") = 1.0 "energy of first electron";
  parameter Real E2(unit = "eV") = 2.0 "energy of second electron";
  parameter Real Eb(unit = "eV") = 10.0 "height of barrier";
  parameter Real Wb(unit = "m") = 0.50 * 10 ^ (-9) "width of barrier";
  Real hbar(unit = "J.s") "reduced Planck's conctaant";
  Real Me(unit = "kg") "mass of electron";
  Real e1(unit = "J/eV") "charge of an electron";
  Real k1(unit = "m^(-1)")"for first electron";
  Real k2(unit = "m^(-1)") "for second electron";
  Real Wb1(unit = "m")"Barrier width doubled";
  Real T11;
  Real T22;
  equation
  hbar = 1.054 * 10 ^ (-34);
  Me = 9.1 * 10 ^ (-31);
  e1 = 1.6 * 10 ^ (-19);
  k1= sqrt(2*Me*(Eb-E1)*e1)/hbar;
  k2= sqrt(2*Me*(Eb-E2)*e1)/hbar;
  Wb1= Wb*2;
  T11= exp((-2)*k1*Wb1); // changed transmission probability for first electron
  T22= exp((-2)*k2*Wb1); //for second electron
  //Sum solved in book is wrong . For Calculating k1, E1 should be considered and for k2 , E2 should be considered. Morever calculated K2 value is wrong 
  end  Ex5_6_b;
































end Ex5_6;
