model Ex8_2
import Modelica.Constants.*;
parameter Real Ji=0"initial state";
parameter Real Jf=1"final state";
parameter Real f(unit = "Hz") = 1.15*(10^11)"frequency for the absorption";
parameter Real h(unit = "J.s") = 6.63*(10^(-34))"Planck's constant";
Real hbar(unit = "J.s")"reduced Planck's constant";
Real Ico(unit = "kg.m^2")"moment of inertia";
Real Mco(unit = "refer Exa 8.1")"Mass of CO";
Real r(unit = "m")"bond length";
Real r1(unit = "nm")"converting to nm";
equation
hbar= h/(2*(pi));
Ico= hbar*Jf/(2*(pi)*f);
Mco= 1.14*(10^(-26));
r= sqrt(Ico/Mco);
r1= r*(10^9);

end Ex8_2;
