package Ex2_2
  model  Ex2_2_a
  parameter Real l(unit = "m") = 350*10^(-9)"Wavelength of UV light";
  //Converted from nm to m
  Real Ep(unit = "eV")"energy of photon";
  Real t(unit = "eV")"work function of Potassium surface";
  Real KEmax(unit = "eV")"Max KE of the phototelectrons";
  equation
  Ep= (1.24*(10^(-6)))/l;
  t= 2.2;
  KEmax= Ep-t;
  end  Ex2_2_a;





model  Ex2_2_b
Real A(unit = "m^2")"Surface area";
parameter Real i(unit = "W/m^2") = 1.00"intensity of UV  light";
Real E(unit = "J")"Photon energy";
Real Np(unit = "per second")"number of incident photon";
Real Ne(unit = "per second")"number of photoeectrons emitted";
equation
A= 10^(-4);
E= 5.68*(10^(-19));
Np= i*A/E;
Ne= (0.0050)*Np;
end  Ex2_2_b;

  
end Ex2_2;
