package Ex4_5
  model Ex4_5_a
    import Modelica.Constants.*;
    parameter Real n1 = 1 "initial state";
    parameter Real n2 = 2 "final state";
    parameter Real E1(unit = "J") = 2.18 * 10 ^ (-18) "Rydberg's constant"; 
    Real f1(unit = "rev/s") "Frequency for first orbit";
    Real f2(unit = "rev/s") "Frequency for second orbit";
  equation
    f1 = E1 / h * (2 / n1 ^ 3);//h(unit = "J.s") = 6.63 * 10 ^ (-34) "Planck's constant";
    f2 = E1 / h * (2 / n2 ^ 3);//h(unit = "J.s") = 6.63 * 10 ^ (-34) "Planck's constant";
  end Ex4_5_a;




  model Ex4_5_b
  import Modelica.Constants.*;
  parameter Real E1(unit = "J") = 2.18 * 10 ^ (-18) "Rydberg's constant";
  parameter Real n1 = 1 "initial state";
  parameter Real n2 = 2 "final state";
  Real f(unit = "Hz")"Intermediate frequency";
  equation
  f= (E1/h)*((1/n2^3)-(1/n1^3));
  end Ex4_5_b;




  model Ex4_5_c
  Real n"orbit";
  parameter Real f(unit="rev/sec")=8.23*10^14 "from part (a)";
  Real dt(unit = "s")" time duration";
  Real N(unit="rev")"Number of revolutions";
  equation
  n= 2;
  dt= 10^(-8);
  N= f*dt; 
  end Ex4_5_c;








end Ex4_5;
