model Ex9_1
import Modelica.Constants.*;
import Modelica.Math.*;
parameter Real k(unit = "eV/K") = 8.617*10^(-5)"Boltzmann constant";
parameter Real To(unit = "K") =273"initial temperature";
parameter Real E1(unit = "eV") = -13.6"energy of ground state";
parameter Real E2(unit = "eV") = -3.4"energy of first excited state";
Real dE"difference in energy levels";
Real g1"number of energy states for E1";
Real g2"number of energy states for E2";
Real J;
Real Nratio1"ratio of number of atoms in level 2 and level 1 at To";
Real T1"K";
Real J1;
Real Nratio2"at T1";
equation
dE= E2-E1;
g1=2;
g2=8;
J= dE/(k*To);
Nratio1= (g2/g1)*exp(-J);
// Ans varies due to apparoximation in value of J
//Solution b
T1=10273;
J1= J*To/T1;
Nratio2= (g2/g1)*(e)^(-J1);
end Ex9_1;
 
