model Ex3_3
import Modelica.Constants.*;
parameter Real a(unit = "mts") = 2*(10^(-12))"de Broglie wavelength";
parameter Real h(unit = "eV.s") = 4.136*(10^(-15))"Planck's constant";
parameter Real c(unit = "m/s") = 3*(10^8)"velocity of light";
Real pc(unit = "keV")"p is momentum";
Real Eo(unit = "keV")"rest energy";
Real E(unit = "keV")"Total Energy";
Real KE(unit = "keV")"Kinetic energy";
Real v(unit="m/s")"electron  velocity";
Real vp(unit="m/s")"Phase velocity";
Real vg(unit="m/s")"group velocity";

equation
//Solution a
pc= ((h*c)/a)/1000;//c(unit = "m/s") = 3*(10^8)"velocity of light";
Eo= 511;
E= sqrt((Eo^2)+(pc^2));//c(unit = "m/s") = 3*(10^8)"velocity of light";
KE= E-Eo;
//Solution b
v= c*(sqrt(1-(Eo^2/E^2))); 
vp= c^2/vg;//c(unit = "m/s") = 3*(10^8)"velocity of light"; 
vg=v; 
end Ex3_3;
