model Ex4_8
import Modelica.Constants.*;
import Modelica.Math.*;
import Modelica.SIunits.Conversions.*;
import SI = Modelica.SIunits;
parameter Real I(unit = "MeV") = 7.7"Intensity of beam";
parameter Real Dgold(unit = "kg/m^3") = 1.93*(10^4)"density of gold foil used";
parameter Real u(unit = "kg") = 1.66*(10^(-27))"atomic mass unit";
Real Mgold(unit = "per atom")"atomic mass of gold";
Real n(unit = "atoms/m^3")"number of atoms per unit volume";
Real Zgold"atomic number of gold";
Real e1(unit = "C")"electronis charge";
Real KE(unit = "J")"converting to J";
parameter SI.Angle  phi= from_deg (45);//converting to radian  
Real Po(unit = "F/m")"Permittivity of free space";
Real t(unit = "m")"thickness of foil";
Real f;
equation
Mgold= 197*u;
n= Dgold/Mgold;
Zgold= 79;
e1= 1.6*(10^(-19));
KE= (I*e1)/(10^(-6));
Po= 8.85*(10^(-12));
t= 3*(10^(-7));
f=(pi)*n*t*((Zgold*(e1^2))/(4*(pi)*Po*KE))^2*(1/tan(phi/2)^2); //using Rutherford scattering formula
end Ex4_8;
