//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.11 page-40
//Topic     : Viscosity and other secondary parameters
//Caption   : A commercial airplane

//===================================================
model Ex1_11

//Parameter section

parameter Real V(unit="mi/h")=540         "Airplane velocity";
parameter Real Altitude(unit="ft")=30000  "Standard Altitude";

//DATA: Table A.6 at 30000ft

parameter Real k(unit="-")=1.4          "ratio = Cp/Cv";
parameter Real R(unit="m2/s^2.K")=287      "Gas constant";
parameter Real T(unit="K")=229            "Absolute temperature";

//===================================================

//Variable section

Real a(unit="m/s")   "Speed of sound";
Real Ma(unit="-")  "Mach number";


//===================================================

//Equation section

equation

// a = (k*R*T)^(0.5)
// Ma = V/a

a = (k*R*T)^(0.5);     //Speed of sound
Ma = (V*0.44704)/a;    //Mach number

//===================================================
end Ex1_11;
//===================================================
