//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.5 page-22
//Topic     : Dimensions and Units
//Caption   : Estimate rho and cp

//===================================================
model Ex1_5

//Parameter section

parameter Real p(unit="lbf/in^2")=100       "Pressure of steam";
parameter Real T(unit="deg.Farenheit")=400  "Temperature";
parameter Real k(unit="Nil")=1.30           "Specific heat ratio";

//DATA: Table A.4
parameter Real Mw(unit="1/mol") = 18.02 "Molecular weight of water";

//===================================================
//Variable section

Real Rsteam(unit="ft.lbf/slug.deg.Rad") "Gas constant fot steam in English units";
Real rho(unit="slug/ft^3")              "Density from perfect gas-law";
Real cp(unit="ft.lbf/slug.deg.Rad")     "Specific heat";

//===================================================
//Equation section

//Using Equations: 
// p = rho*R*T
// R = Cp - Cv
// k = Cp/Cv

equation

Rsteam = (49700/Mw);
cp  =(k*Rsteam)/(k-1);
//USING: Eq. 1.10
rho = ((p/0.006944)/(Rsteam*(T+460)));
//CONVERSION: deg.F to deg.R
//CONVERSION: (lbf/in^2) to (lbf/ft^2)

//===================================================
end Ex1_5;
//===================================================
