//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.8 page-34
//Topic     : Dimensions and Units
//Caption   : Derive an expression for change in height

//===================================================
model Ex1_8

extends Modelica.Math;

//Parameter section

//GIVEN: Fig. E1.8.

parameter Real R(unit="mm")=1           "Tube Radius";
parameter Real A1(unit="deg.")=0     "Contact angle in water-air-glass";
parameter Real A2(unit="deg.")=130   "Contact angle in mercury-air-glass";
parameter Real Lam1(unit="N/m")=0.073   "Surface tension in water-air-glass";
parameter Real Lam2(unit="N/m")=0.48    "Surface tension in mercury-air-glass";
parameter Real Rho1(unit="kg/m^3")=1000  "Water density";
parameter Real Rho2(unit="kg/m^3")=13600 "Mercury density";
parameter Real g(unit="m/s^2")=9.81      "Acceleration due to gravity";


//===================================================

//Variable section

Real h1(unit="cm")  "height increase - water-air-glass";
Real h2(unit="cm")  "height increase - mercury-air-glass";


//===================================================

//Equation section

// h = 2*surface tension*contact angle/(Force disnity*tube radius)

equation

h1=((2*Lam1*cos(A1*0.0175))/(Rho1*g*(R*(1/1000))))*(100);     //Capillary rise for water-air-glass
//Degree is converted to Radian

h2=((2*Lam2*cos(A2*0.0175))/(Rho2*g*(R*(1/1000))))*(100);    //Capillary rise for mercury-air-glass
//Degree is converted to Radian

//===================================================
end Ex1_8;
//===================================================
