//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.12 page-739
//Topic      : Flow Measurement and Control by Weirs
//Caption    : A V notch weir is to be designed to meter an irrigation channel

//===================================================
model Ex10_12


extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter

parameter Real Q(unit="m^3/h") = 150    "Volumetric flow rate";
parameter Real H(unit="cm") = 30        "Water level";
parameter Real Cd(unit="-") = 0.44      "Drag coefficient";

//Variable
Real theta(unit="Deg.") "Notch angle";

//Equation
equation
(theta)=(180/3.14)*2*(atan((Q/3600)/(Cd*sqrt(g)*(H/100)^2.5)));

//===================================================
end Ex10_12;
//===================================================
