//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.2 page-710
//Topic      : Uniform flow; The Chezy Formula
//Caption    : Engineers find that the most efficient channel

//===================================================
model Ex10_2

//Parameter
parameter Real Q(unit="ft^3/s") = 100 "Volumetric flow rate";
parameter Real S(unit="-") = 0.006 "Channel slope";

//DATA: Table 10.1
parameter Real n(unit="-") = 0.015 "Roughness factor";
parameter Real alpha(unit="-") = 1.486 "Conversion factor";

//===================================================

//Variable

Real b(unit="ft") "Bottom width";

//===================================================

//Equation

equation

(Q)=((alpha/n)*(b*b/2)*((b/4)^(2/3))*(S^0.5));

//===================================================
end Ex10_2;
//===================================================
